package com.androidbook.useservice;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Location;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

import com.androidbook.simpleservice.IRemoteInterface;
import com.androidbook.simpleservice.GPXPoint;

public class UseService extends Activity implements ServiceConnection {
    IRemoteInterface mRemoteInterface = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        
        final TextView status = (TextView) findViewById(R.id.status);
        


        Button go = (Button) findViewById(R.id.go);
        go.setOnClickListener(new View.OnClickListener() {

            public void onClick(View v) {
                Intent service = new Intent("com.androidbook.GPXService.SERVICE");
                service.putExtra("update-rate", 7500);
                startService(service);
            }

        });
        Button stop = (Button) findViewById(R.id.stop);
        stop.setOnClickListener(new View.OnClickListener() {

            public void onClick(View v) {
                stopService(new Intent("com.androidbook.GPXService.SERVICE"));
            }
        });
        
        
        Button getLastLoc = (Button) findViewById(R.id.get_last);
        
        getLastLoc.setOnClickListener(new View.OnClickListener() {

            public void onClick(View v) {
                
                try {
                    String info = "Informacje z usługi: \n";
                    Location loc = mRemoteInterface.getLastLocation();
                    if (loc != null) {
                        double lat = loc.getLatitude();
                        double lon = loc.getLongitude();
                        info += String.format("Ostatnia lokalizacja = (%f, %f)\n", lat, lon);
                    } else {
                        info += "Brak ostatniej lokalizacji.\n";
                    }
                    
                    GPXPoint point = mRemoteInterface.getGPXPoint();
                    if (point != null) {
                        info += String.format("Lokalizacja GPX = (%d, %d) na wysokości %.1f metrów o godzinie %s\n", 
                                point.latitude, 
                                point.longitude,
                                point.elevation, 
                                point.timestamp.toLocaleString());
                        
                    }
                                
                    status.setText(info);
                    
                } catch (RemoteException e) {
                    Log.e("ServiceControl", "Błąd wywołania zdalnego interfejsu.", e);
                }
            }
            
        });
        
      
        
    }

    public void onServiceConnected(ComponentName name, IBinder service) {
        mRemoteInterface = IRemoteInterface.Stub.asInterface(service);
        Log.v("ServiceControl", "Interfejs powiązany.");
        Button getLastLoc = (Button) findViewById(R.id.get_last);
        getLastLoc.setVisibility(View.VISIBLE);
        
        
    }

    public void onServiceDisconnected(ComponentName name) {
        mRemoteInterface = null;
        Button getLastLoc = (Button) findViewById(R.id.get_last);
        getLastLoc.setVisibility(View.GONE);
        Log.v("ServiceControl", "Zdalny interfejs nie jest już powiązany.");
    }

    @Override
    protected void onResume() {
        super.onResume();
        // uzyskanie połączenia z naszą zdalną usługą
        //bindService(new Intent(IRemoteInterface.class.getName()), this, Context.BIND_AUTO_CREATE);
        bindService(new Intent("com.androidbook.GPXService.SERVICE"), this, Context.BIND_AUTO_CREATE);
    }

    @Override
    protected void onPause() {
        // usunięcie połączenia ze zdalną usługą
        unbindService(this);
        super.onPause();
    }

}